/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;
import org.fife.ui.rsyntaxtextarea.folding.FoldParserManager;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoldManager {
    private RSyntaxTextArea textArea;
    private FoldParser parser;
    private List<Fold> folds;
    private boolean codeFoldingEnabled;
    private PropertyChangeSupport support;
    public static final String PROPERTY_FOLDS_UPDATED = "FoldsUpdated";
    private Parser tempParser;

    public FoldManager(RSyntaxTextArea textArea) {
        this.textArea = textArea;
        this.support = new PropertyChangeSupport(this);
        Listener l = new Listener();
        textArea.getDocument().addDocumentListener(l);
        textArea.addPropertyChangeListener("RSTA.syntaxStyle", l);
        this.folds = new ArrayList<Fold>();
        this.updateFoldParser();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void clear() {
        this.folds.clear();
    }

    public boolean ensureOffsetNotInClosedFold(int offs) {
        boolean foldsOpened = false;
        for (Fold fold2 = this.getDeepestFoldContaining(offs); fold2 != null; fold2 = fold2.getParent()) {
            if (!fold2.isCollapsed()) continue;
            fold2.setCollapsed(false);
            foldsOpened = true;
        }
        return foldsOpened;
    }

    public Fold getDeepestFoldContaining(int offs) {
        Fold deepestFold = null;
        if (offs > -1) {
            for (int i = 0; i < this.folds.size(); ++i) {
                Fold fold2 = this.getFold(i);
                if (!fold2.containsOffset(offs)) continue;
                deepestFold = fold2.getDeepestFoldContaining(offs);
                break;
            }
        }
        return deepestFold;
    }

    public Fold getDeepestOpenFoldContaining(int offs) {
        Fold deepestFold = null;
        if (offs > -1) {
            for (int i = 0; i < this.folds.size(); ++i) {
                Fold fold2 = this.getFold(i);
                if (!fold2.containsOffset(offs)) continue;
                if (fold2.isCollapsed()) {
                    return null;
                }
                deepestFold = fold2.getDeepestOpenFoldContaining(offs);
                break;
            }
        }
        return deepestFold;
    }

    public Fold getFold(int index2) {
        return this.folds.get(index2);
    }

    public int getFoldCount() {
        return this.folds.size();
    }

    public Fold getFoldForLine(int line) {
        return this.getFoldForLineImpl(null, this.folds, line);
    }

    private Fold getFoldForLineImpl(Fold parent, List<Fold> folds, int line) {
        int low = 0;
        int high = folds.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Fold midFold = folds.get(mid);
            int startLine = midFold.getStartLine();
            if (line == startLine) {
                return midFold;
            }
            if (line < startLine) {
                high = mid - 1;
                continue;
            }
            int endLine = midFold.getEndLine();
            if (line >= endLine) {
                low = mid + 1;
                continue;
            }
            List<Fold> children2 = midFold.getChildren();
            return children2 != null ? this.getFoldForLineImpl(midFold, children2, line) : null;
        }
        return null;
    }

    public int getHiddenLineCount() {
        int count2 = 0;
        for (Fold fold2 : this.folds) {
            count2 += fold2.getCollapsedLineCount();
        }
        return count2;
    }

    public int getHiddenLineCountAbove(int line) {
        return this.getHiddenLineCountAbove(line, false);
    }

    public int getHiddenLineCountAbove(int line, boolean physical) {
        int count2 = 0;
        for (Fold fold2 : this.folds) {
            int comp;
            int n = comp = physical ? line + count2 : line;
            if (fold2.getStartLine() >= comp) break;
            count2 += this.getHiddenLineCountAboveImpl(fold2, comp, physical);
        }
        return count2;
    }

    private int getHiddenLineCountAboveImpl(Fold fold2, int line, boolean physical) {
        int count2 = 0;
        if (fold2.getEndLine() < line || fold2.isCollapsed() && fold2.getStartLine() < line) {
            count2 = fold2.getCollapsedLineCount();
        } else {
            int childCount = fold2.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                int comp;
                Fold child = fold2.getChild(i);
                int n = comp = physical ? line + count2 : line;
                if (child.getStartLine() >= comp) break;
                count2 += this.getHiddenLineCountAboveImpl(child, comp, physical);
            }
        }
        return count2;
    }

    public int getLastVisibleLine() {
        Fold lastFold;
        int foldCount;
        int lastLine = this.textArea.getLineCount() - 1;
        if (this.isCodeFoldingSupportedAndEnabled() && (foldCount = this.getFoldCount()) > 0 && (lastFold = this.getFold(foldCount - 1)).containsLine(lastLine)) {
            if (lastFold.isCollapsed()) {
                lastLine = lastFold.getStartLine();
            } else {
                while (lastFold.getHasChildFolds() && (lastFold = lastFold.getLastChild()).containsLine(lastLine)) {
                    if (!lastFold.isCollapsed()) continue;
                    lastLine = lastFold.getStartLine();
                    break;
                }
            }
        }
        return lastLine;
    }

    public int getVisibleLineAbove(int line) {
        if (line <= 0 || line >= this.textArea.getLineCount()) {
            return -1;
        }
        while (--line >= 0 && this.isLineHidden(line)) {
        }
        return line;
    }

    public int getVisibleLineBelow(int line) {
        int lineCount = this.textArea.getLineCount();
        if (line < 0 || line >= lineCount - 1) {
            return -1;
        }
        while (++line < lineCount && this.isLineHidden(line)) {
        }
        return line == lineCount ? -1 : line;
    }

    public boolean isCodeFoldingEnabled() {
        return this.codeFoldingEnabled;
    }

    public boolean isCodeFoldingSupportedAndEnabled() {
        return this.codeFoldingEnabled && this.parser != null;
    }

    public boolean isFoldStartLine(int line) {
        return this.getFoldForLine(line) != null;
    }

    public boolean isLineHidden(int line) {
        for (Fold fold2 : this.folds) {
            if (!fold2.containsLine(line)) continue;
            if (fold2.isCollapsed()) {
                return true;
            }
            return this.isLineHiddenImpl(fold2, line);
        }
        return false;
    }

    private boolean isLineHiddenImpl(Fold parent, int line) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Fold child = parent.getChild(i);
            if (!child.containsLine(line)) continue;
            if (child.isCollapsed()) {
                return true;
            }
            return this.isLineHiddenImpl(child, line);
        }
        return false;
    }

    private void keepFoldState(Fold newFold, List<Fold> oldFolds) {
        int previousLoc = Collections.binarySearch(oldFolds, newFold);
        if (previousLoc >= 0) {
            Fold prevFold = oldFolds.get(previousLoc);
            newFold.setCollapsed(prevFold.isCollapsed());
        } else {
            List<Fold> children2;
            Fold possibleParentFold;
            int insertionPoint = -(previousLoc + 1);
            if (insertionPoint > 0 && (possibleParentFold = oldFolds.get(insertionPoint - 1)).containsOffset(newFold.getStartOffset()) && (children2 = possibleParentFold.getChildren()) != null) {
                this.keepFoldState(newFold, children2);
            }
        }
    }

    private void keepFoldStates(List<Fold> newFolds, List<Fold> oldFolds) {
        for (Fold newFold : newFolds) {
            this.keepFoldState(newFold, this.folds);
            List<Fold> newChildFolds = newFold.getChildren();
            if (newChildFolds == null) continue;
            this.keepFoldStates(newChildFolds, oldFolds);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    public void reparse() {
        if (this.codeFoldingEnabled && this.parser != null) {
            List<Fold> newFolds = this.parser.getFolds(this.textArea);
            if (newFolds == null) {
                newFolds = Collections.emptyList();
            } else {
                this.keepFoldStates(newFolds, this.folds);
            }
            this.folds = newFolds;
            this.support.firePropertyChange(PROPERTY_FOLDS_UPDATED, null, this.folds);
            this.textArea.repaint();
        } else {
            this.folds.clear();
        }
    }

    public void setCodeFoldingEnabled(boolean enabled) {
        if (enabled != this.codeFoldingEnabled) {
            this.codeFoldingEnabled = enabled;
            if (this.tempParser != null) {
                this.textArea.removeParser(this.tempParser);
            }
            if (enabled) {
                this.tempParser = new AbstractParser(){

                    public ParseResult parse(RSyntaxDocument doc, String style) {
                        FoldManager.this.reparse();
                        return new DefaultParseResult(this);
                    }
                };
                this.textArea.addParser(this.tempParser);
                this.support.firePropertyChange(PROPERTY_FOLDS_UPDATED, null, null);
            } else {
                this.folds = Collections.emptyList();
                this.textArea.repaint();
                this.support.firePropertyChange(PROPERTY_FOLDS_UPDATED, null, null);
            }
        }
    }

    public void setFolds(List<Fold> folds) {
        this.folds = folds;
    }

    private void updateFoldParser() {
        this.parser = FoldParserManager.get().getFoldParser(this.textArea.getSyntaxEditingStyle());
    }

    private class Listener
    implements DocumentListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            Fold fold2;
            int endLine;
            int startOffs = e.getOffset();
            int endOffs = startOffs + e.getLength();
            Document doc = e.getDocument();
            Element root2 = doc.getDefaultRootElement();
            int startLine = root2.getElementIndex(startOffs);
            if (startLine != (endLine = root2.getElementIndex(endOffs)) && (fold2 = FoldManager.this.getFoldForLine(startLine)) != null && fold2.isCollapsed()) {
                fold2.toggleCollapsedState();
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            FoldManager.this.updateFoldParser();
            FoldManager.this.reparse();
        }

        public void removeUpdate(DocumentEvent e) {
            int offs = e.getOffset();
            try {
                int lastLineModified = FoldManager.this.textArea.getLineOfOffset(offs);
                Fold fold2 = FoldManager.this.getFoldForLine(lastLineModified);
                if (fold2 != null && fold2.isCollapsed()) {
                    fold2.toggleCollapsedState();
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
    }
}

